﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;
using CommandLine;

namespace OGSNET
{
    /** \brief プログラムのエントリーポイント */
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main(string [] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            CommandLineParser parser = new CommandLineParser();
            CommandLineOption option = CommandLineOption.GetInstance();

            parser.ParseArguments(args, option);

            Application.Run(new MainForm());
        }
    }

    /** \brief 文字列のペアを格納する構造体 */
    public struct StringPair :
        IComparable,
        IComparable<StringPair>
    {
        public string First;
        public string Second;

        public StringPair(string first, string second)
        {
            this.First = first;
            this.Second = second;
        }

        public override string ToString()
        {
            return this.Second;
        }

        public int CompareTo(object obj)
        {
            if (obj is StringPair)
            {
                return this.CompareTo((StringPair)obj);
            }

            throw new NotImplementedException();
        }

        public int CompareTo(StringPair other)
        {
            if (this.Second != other.Second)
            {
                return this.Second.CompareTo(other.Second);
            }

            return this.First.CompareTo(other.First);
        }
    }

    /** \brief コマンドラインオプション */
    public class CommandLineOption
    {
        private static CommandLineOption Instance;

        /** \brief プラグインのデバッグモードかどうか */
        [Option(null, "PluginDebug")]
        public bool PluginDebug = false;

        [Option("i", "PluginId")]
        public string PluginId = null;

        [Option("u", "UserName")]
        public string UserName = null;

        [Option("p", "Password")]
        public string Password = null;

        /** \brief インスタンス作成不可 */
        private CommandLineOption() { }

        /** \breif Singleton の実装 */
        public static CommandLineOption GetInstance()
        {
            if (CommandLineOption.Instance == null)
            {
                CommandLineOption.Instance = new CommandLineOption();
            }

            return CommandLineOption.Instance;
        }
    }
}
